import _mergeJSXProps from "babel-helper-vue-jsx-merge-props";
export default {
  name: 'ApertureIcon',
  props: {
    size: {
      type: String,
      default: '24',
      validator: function validator(s) {
        return !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x';
      }
    }
  },
  functional: true,
  render: function render(h, ctx) {
    var size = ctx.props.size.slice(-1) === 'x' ? ctx.props.size.slice(0, ctx.props.size.length - 1) + 'em' : parseInt(ctx.props.size) + 'px';
    var attrs = ctx.data.attrs || {};
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    ctx.data.attrs = attrs;
    return h("svg", _mergeJSXProps([{
      attrs: {
        xmlns: "http://www.w3.org/2000/svg",
        width: "24",
        height: "24",
        viewBox: "0 0 24 24",
        fill: "none",
        stroke: "currentColor",
        "stroke-width": "2",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      },
      "class": "feather feather-aperture"
    }, ctx.data]), [h("circle", {
      attrs: {
        cx: "12",
        cy: "12",
        r: "10"
      }
    }), h("line", {
      attrs: {
        x1: "14.31",
        y1: "8",
        x2: "20.05",
        y2: "17.94"
      }
    }), h("line", {
      attrs: {
        x1: "9.69",
        y1: "8",
        x2: "21.17",
        y2: "8"
      }
    }), h("line", {
      attrs: {
        x1: "7.38",
        y1: "12",
        x2: "13.12",
        y2: "2.06"
      }
    }), h("line", {
      attrs: {
        x1: "9.69",
        y1: "16",
        x2: "3.95",
        y2: "6.06"
      }
    }), h("line", {
      attrs: {
        x1: "14.31",
        y1: "16",
        x2: "2.83",
        y2: "16"
      }
    }), h("line", {
      attrs: {
        x1: "16.62",
        y1: "12",
        x2: "10.88",
        y2: "21.94"
      }
    })]);
  }
};