const express = require("express");
const app = express();
const fs = require("fs");
const WebSocket = require("ws");
const server = require("https").createServer(
  {
    key: fs.readFileSync("/etc/letsencrypt/live/chat.prayer4.me/privkey.pem"),
    cert: fs.readFileSync("/etc/letsencrypt/live/chat.prayer4.me/cert.pem"),
  },
  app
);
var io = require("socket.io")(server, {
  pingTimeout: 25000,
  pingInterval: 60000,
  // cors: {
  //   origins: ["https://localhost:8080"],
  // },
});

const port = 3000;

app.get("/", (req, res) => {
  res.send("<h1>Hey Socket.io</h1>");
});

//app.use(express.static(__dirname + '/public'));
// io.on("connect", onConnect);
io.on("connection", function (socket) {
  console.log("a user connected");
  socket.on("disconnect", () => {
    console.log("user disconnected");
  });

  socket.on("newchatmessagesend", (msg) => {
    console.log(msg);
    io.emit("newmessagereceived", msg);
  });
});

server.listen(port, () => {
  console.log("listening on *: " + port);
});
