'use strict';

(function () {

  var socket = io();
  socket.on('connect', onConnect);
  var activeAllGroup = $("#activeAllGroup");
  var chatDetailsHeading = $("#chatDetailsHeading");
  var userName = $("#userName");
  var userFullName = $("#userFullName");
  var role = $("#role");
  var phone = $("#phone");
  var activeGroupId = $("#activeGroupId");


  var message = $("#message");
  var send_message = $("#send_message");

  var chatroom = $("#chatroom");
  var feedback = $("#feedback");

  var searchBox = $("#search_box");

  function onConnect() {
//       socket.on('ping', function(data){
//     socket.emit('pong', { beat: 1 });
//     console.log('ping in socket');
// }); 
  }
  var activeAllGroup = $("#activeAllGroup");
  var chatDetailsHeading = $("#chatDetailsHeading");
  var userName = $("#userName");
  var userFullName = $("#userFullName");
  var role = $("#role");
  var phone = $("#phone");
  var activeGroupId = $("#activeGroupId");


  var message = $("#message");
  var send_message = $("#send_message");

  var chatroom = $("#chatroom");
  var feedback = $("#feedback");

  var searchBox = $("#search_box");

  /*
   **@START : Get Group details
   */
  window.onload = function () {
    // console.log('window loaded');
    var sPageURL = window.location.href;
    //var userId = sPageURL.split('?id=')[1];
    var userId = window.location.href.split('/').pop();
    // console.log(userId);
    socket.emit('pageReady', {
      userId: userId
    });
    $(".messages").animate({ scrollTop: getHeightOfChat() }, "slow");
  }
  /*
   **@END : Get Group details
   */

  socket.on("userNotFound", data => {
    // console.log('User NOT Found');
    alert('Invalid URL! Please continue with a valid one.');
  });




  /*
   **@START : Response for all Group details
   */
  socket.on("sendAllGroupDetals", data => {
    if (socket.id == data.socketId) {
      // console.log(data);
      activeAllGroup.html('');
      userName.text(data.userDetails.first_name + ' ' + data.userDetails.last_name);
      $('.profile-name-short').text(data.userDetails.short_name);
      $('.group-name-short').text(data.activeGroups[0].mob_group_id);
      userFullName.val(data.userDetails.first_name + ' ' + data.userDetails.last_name);
      role.val(data.userDetails.company_id == null ? 'Requester' : 'Responder');
      phone.val(data.userDetails.phone);

      /*
       **@For : Check group array empty or not
       **
       **@ACTION : If not empty then then fetch the message for the first group
       */
      if (data.activeGroups.length > 0) {
        chatDetailsHeading.text('Chat with ' + data.activeGroups[0].group_id);
        socket.emit("findTheGroupChat", {
          findTheGroup: data.activeGroups[0].group_id
        });
      }

      /*
       **@For : Listing all group array
       **
       */
      for (var i = 0; i < data.activeGroups.length; i++) {
        var status = ' online';
        var typingInd = '<div class="ticontainer"><div class="tiblock"><div class="tidot"></div><div class="tidot"></div><div class="tidot"></div></div></div>';
        if (data.activeGroups[i].check_expired_at == 0) {
          status = ' busy';
        }

        var dateStr = dateTimeFormat(new Date(convertUTCDateToLocalDate(new Date(data.activeGroups[i].expired_at_format))));

        var activeClass = (i == 0) ? ' active' : '';
        activeAllGroup.append(
          '<li class="contact' + activeClass + '" data-groupId="' + data.activeGroups[i].group_id + '" >' +
          '<div class="wrap" id="' + data.activeGroups[i].group_id + '">' +
          '<span class="contact-status' + status + '"></span>' +
          typingInd +
          '<div class="meta">' +
          '<p class="name">' + data.activeGroups[i].group_id + '</p>' +
          '<p class="name mobIcon">' + data.activeGroups[i].mob_group_id + '</p>' +
          '<p class="preview"><span>' + data.activeGroups[i].first_name + ' ' + data.activeGroups[i].last_name + '<br>Exp: ' + dateStr[2] + '</span></p>' +
          '</div>' +
          '</div>' +
          '</li>'
        );
      }
    }
  });
  /*
   **@END : Response for all Group details
   */


  /*
   **@START : Get message on switching the group
   */
  $('body').on('click', '#activeAllGroup li', function () {
    $(this).siblings().removeClass('active');
    $(this).addClass('active');
    // console.log($(this).attr("data-groupId"));
    chatDetailsHeading.text('Chat with ' + $(this).attr("data-groupId"));
    socket.emit("findTheGroupChat", {
      findTheGroup: $(this).attr("data-groupId")
    });
  });
  /*
   **@END : Get message on switching the group
   */

  /*
   **@START : Response for message of a group
   */
  socket.on("sendGroupChatDetals", data => {
    // console.log(data);
    /*
     **@For : Check it's a right window or not
     **
     */
    if (data.socketId == socket.id) {
      chatroom.html('');
      feedback.html("");
      if (data.result == "success") {
        activeGroupId.text(data.findTheGroup.group_id)
      	$('.group-name-short').text(data.findTheGroup.mob_group_id);

        if (data.findTheGroup.check_expired_at == 0) {
          $('body').find("#message-input").addClass("displayNone");
        } else {
          $('body').find("#message-input").removeClass("displayNone");
        }

        var createdDateMsg = '';
        for (var i = 0; i < data.resultMsg.length; i++) {
          // console.log(data.resultMsg[i]);
          // console.log('*******');
          // console.log(new Date(data.resultMsg[i].created_at).toString('yyyy-MM-dd H:i:s'));

          /*
           **@For : Check the user who send the message or not
           **
           **@ACTION : If user as sender then execute the if block or execute the else part
           */

          // console.log(data.resultMsg[i].created_datetime);
          var dateStr = dateTimeFormat(new Date(convertUTCDateToLocalDate(new Date(data.resultMsg[i].created_datetime))));
          // console.log(convertUTCDateToLocalDate(new Date(data.resultMsg[i].created_datetime)));
          // console.log('=========');
          // console.log(dateStr);

          if (dateStr[0] !== createdDateMsg) {
            chatroom.append(
              '<li class="chatDate">' +
              '<p><span class="msg_date">' + dateStr[0] + '</span>' +
              '</p>' +
              '</li>'
            );
            createdDateMsg = dateStr[0];
          }

          var classSentOrReplies = 'sent';
          if (data.resultMsg[i].msg_from_id == data.findYourself.id) {
            classSentOrReplies = 'replies';
          }
          chatroom.append(
            '<li class="' + classSentOrReplies + '">' +
            '<p><span class="msg_person">' + data.resultMsg[i].first_name + ' :</span><span class="msg_time">' + dateStr[1] + '</span><br>' + data.resultMsg[i].msg_body +
            '</p>' +
            '</li>'
          );
        }
        
        $(".messages").animate({ scrollTop: getHeightOfChat() }, "slow");
      }
    }
  });
  /*
   **@END : Response for message of a group
   */

  /*
   **@START : Save the sending message
   */
  send_message.click(() => {
    if (message.val() != '')
      socket.emit("new_message", {
        message: message.val()
      });
    message.val("");

  });
  /*
   **@END : Save the sending message
   */

  /*
   **@START : Response after message save of a group
   */
  socket.on("new_message", data => {
    var associated_socket_ids=[];
    $('#activeAllGroup li').each(function(){
      associated_socket_ids.push($(this).attr('data-groupid'));
    });
    if($.inArray( data.socketId, associated_socket_ids )){
     // showDesktopNotification(data.yourDetail.first_name + ' ' + data.yourDetail.last_name + ' ' + + data.yourDetail.id, data.message);  
    }

    console.log(data.userId);

      console.log(socket.id);
    for (var i = 0; i < data.groupSocketIds.length; i++) {
      $('body').find('#' + data.groupSocketIds[i].group_id).children('img').removeClass('away');
      $('body').find('#' + data.groupSocketIds[i].group_id).children('.ticontainer').css({
        "visibility": "hidden",
        "opacity": "0"
      });
      // var dateStr = dateTimeFormat(new Date(data.dateTime));
      var dateStr = dateTimeFormat(new Date(convertUTCDateToLocalDate(new Date(data.dateTime))));

      /*
       **@For : Check the user who send the message or not and active window to populate the message
       **
       **@ACTION : If user as sender then execute the if block or execute the else part
       */

      if ($("body").find('.msg_date').last().text() !== dateStr[0]) {
        chatroom.append(
          '<li class="chatDate">' +
          '<p><span class="msg_date">' + dateStr[0] + '</span>' +
          '</p>' +
          '</li>'
        );
      }

      var classSentOrReplies = '';
      if ((data.groupSocketIds[i].user_id == data.userId) && (data.groupSocketIds[i].socket_id == socket.id)) {

        /*
         **@For : Check the that, This message is first time chat started by responder or not
         **
         **@ACTION : If it is first message then notify to the requester
         */
        if (data.isFirstTimeChatStartedByResponder == 'Y') {
          // console.log('first-response-notification-to-requester');
          $.post("https://dashboard.prayer4.me/api/first-response-notification-to-requester", {
            group_id: data.groupDetals.group_id,
            company_id: data.groupDetals.	company_id,
            requester_id: data.groupDetals.requester_id
          }, function (data) {
            console.log(data);
          });
        } 
        /*
        **END
        */

        classSentOrReplies = 'replies';
        chatroom.append(
          '<li class="' + classSentOrReplies + '">' +
          '<p><span class="msg_person">' + data.yourDetail.first_name + ' :</span><span class="msg_time">' + dateStr[1] + '</span><br>' + data.message +
          '</p>' +
          '</li>'
        );
        $(".messages").animate({ scrollTop: getHeightOfChat() }, "slow");
        feedback.html("");
        break;
      } else if ((data.groupSocketIds[i].user_id != data.userId) && (data.groupSocketIds[i].socket_id == socket.id)) {
        /*
         **@For : Check the that, This message is first time chat started by responder or not
         **
         **@ACTION : If it is first message then update group details of others
         */

       

        if (data.isFirstTimeChatStartedByResponder == 'Y') {
          socket.emit("findTheGroupChat", {
            findTheGroup: data.groupDetals.group_id
          });
          break;
        }
        /*
        **END
        */

        classSentOrReplies = 'sent';
        chatroom.append(
          '<li class="' + classSentOrReplies + '">' +
          '<p><span class="msg_person">' + data.yourDetail.first_name + ' :</span><span class="msg_time">' + dateStr[1] + '</span><br>' + data.message +
          '</p>' +
          '</li>'
        );
        $(".messages").animate({ scrollTop: getHeightOfChat() }, "slow");
        feedback.html("");
        showDesktopNotification(data.yourDetail.first_name + ' ' + data.yourDetail.last_name + ' ' + data.yourDetail.id, data.message); 

        break;
      }
    }
  });
  /*
   **@END : Response after message save of a group
   */

  /*
   **@START : For typing message indication generate
   */
  $('body').on('keyup', "#message", debounce(function (e) {
    if (e.which == 13) {
      if (message.val().trim() != '')
        socket.emit("new_message", {
          message: message.val()
        });
      message.val("");
    } else {
      socket.emit("typing");
    }
  }, 200));
  /*
   **@END : For typing message indication generate
   */

  /*
   **@START : Response for typing message indication
   */
  socket.on("typing", data => {
    // console.log(data);
    // console.log(socket.id);
    feedback.html("");
    for (var i = 0; i < data.groupSocketIds.length; i++) {
      $('body').find('#' + data.groupSocketIds[i].group_id).children('.ticontainer').css({
        "visibility": "visible",
        "opacity": "1"
      });
      $('body').find('#' + data.groupSocketIds[i].group_id).children('img').addClass('away');
      if ((socket.id == data.groupSocketIds[i].socket_id) && (data.userId != data.groupSocketIds[i].user_id)) {
        feedback.html("<p><i>" + data.yourDetail.first_name + ' ' + data.yourDetail.last_name + ' ' + + data.yourDetail.id + " is typing... </i></p>");
        // console.log(data);
      }
    }
  });
  /*
   **@END : Response for typing message indication
   */

  /*
   **@START : Find the group list on Search
   */
  $('body').on('keyup', "#search_box", debounce(function () {
    socket.emit("searchGroup", {
      search: searchBox.val()
    });
  }, 200));
  /*
   **@END : Find the group list on Search
   */

  /*
   **@START : Response for group list on Search
   */
  socket.on("sendSearchingGroup", data => {
    // console.log(data);
    // console.log(socket.id);
    // console.log(data.activeGroups.length);
    if (socket.id == data.socketId) {
      activeAllGroup.html('');
      if (data.activeGroups.length != 0) {
        for (var i = 0; i < data.activeGroups.length; i++) {

          var status = ' online';
          var typingInd = '<div class="ticontainer"><div class="tiblock"><div class="tidot"></div><div class="tidot"></div><div class="tidot"></div></div></div>';
          if (data.activeGroups[i].check_expired_at == 0) {
            status = ' busy';
          }

          var dateStr = dateTimeFormat(new Date(convertUTCDateToLocalDate(new Date(data.activeGroups[i].expired_at_format))));
          var activeClass = (data.activeGroups[i].group_id == data.groupDetals.group_id) ? ' active' : '';

          activeAllGroup.append(
            '<li class="contact' + activeClass + '" data-groupId="' + data.activeGroups[i].group_id + '" >' +
            '<div class="wrap" id="' + data.activeGroups[i].group_id + '">' +
            '<span class="contact-status' + status + '"></span>' +
            typingInd +
            '<div class="meta">' +
            '<p class="name">' + data.activeGroups[i].group_id + '</p>' +
            '<p class="name mobIcon">' + data.activeGroups[i].mob_group_id + '</p>' +
            '<p class="preview"><span>' + data.activeGroups[i].first_name + ' ' + data.activeGroups[i].last_name + '<br>Exp: ' + dateStr[2] + '</span></p>' +
            '</div>' +
            '</div>' +
            '</li>'
          );
        }
      } else {
        activeAllGroup.append(
          '<li class="contact">' +
          '<div class="wrap">' +
          '<span class="contact-status"></span>' +
          '<img src="https://www.theblogstarter.com/wp-content/themes/germaniumify/images/thumbnail.jpg">' +
          '<div class="meta">' +
          '<p class="name">No Data Found</p>' +
          '<p class="name mobIcon">NDF</p>' +
          '<p class="preview"><span></span></p>' +
          '</div>' +
          '</div>' +
          '</li>'
        );
      }
    }
  });
  /*
   **@END : Response for group list on Search
   */
  socket.on('disconnect', function (reason) {
    // console.log('User us1 disconnected because ' + reason);
    console.log(reason);
    if (reason == 'transport close') {
      // console.log('reloading the page');
      if (!alert('Session out! Want to continue?'))
        window.location.reload();
    }
  });

  /*
   **@START : For typing message indication generate call delay
   */
  function debounce(func, wait, immediate) {
    var timeout;
    return function () {
      var context = this,
        args = arguments;
      var later = function () {
        timeout = null;
        if (!immediate)
          func.apply(context, args);
      };
      var callNow = immediate && !timeout;
      clearTimeout(timeout);
      timeout = setTimeout(later, wait);
      if (callNow)
        func.apply(context, args);
    };
  }
  /*
   **@END : For typing message indication generate call delay
   */

  /*
   **@START : For date time format
   */
  function dateTimeFormat(datetime) {
    var days = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
    const monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];

    var curr_day = days[datetime.getDay()];
    var curr_date = datetime.getDate();
    var curr_month = monthNames[datetime.getMonth()];
    var curr_year = datetime.getFullYear();

    var curr_hour = datetime.getHours();
    var ampm = curr_hour >= 12 ? 'PM' : 'AM';
    curr_hour = curr_hour % 12;
    var curr_min = (datetime.getMinutes() < 10 ? '0' : '') + datetime.getMinutes();
    var curr_sec = (datetime.getSeconds() < 10 ? '0' : '') + datetime.getSeconds();
    var year_2d = curr_year.toString().substring(2, 4)

    var dateStr = [curr_day + " " + curr_date + " " + curr_month + ", " + curr_year, curr_hour + ":" + curr_min + " " + ampm, curr_day + " " + curr_date + " " + curr_month + ", " + curr_year + " " + curr_hour + ":" + curr_min + " " + ampm];
    return dateStr;
  }

  function convertUTCDateToLocalDate(date) {
    var newDate = new Date(date + ' UTC');
    return newDate.toString();
  }
  /*
   **@END : For date time format
   */


  function getHeightOfChat(date) { 
    var height = 0;
  	$('#chatroom li').each(function(i, value){
  	    height += parseInt($(this).height());
  	});
    // console.log(height);
  	return parseInt(height) + 1500;
  }

  var Notification = window.Notification || window.mozNotification || window.webkitNotification;
  Notification.requestPermission(function (permission) {
  });
  /**
   * Request Browser Notification Permission 
   * @type Arguments
   */
  function requestNotificationPermissions() {
    if (Notification.permission !== 'denied') {
      Notification.requestPermission(function (permission) {
      });
    }
  }

  function showDesktopNotification(message, body, sound, timeout) {
    if (!timeout) {
      timeout = 4000;
    }
    requestNotificationPermissions();
    var instance = new Notification(
      message, {
      body: body,
      sound: sound
    }
    );
    instance.onclick = function () {
      // Something to do
    };
    instance.onerror = function () {
      // Something to do
    };
    instance.onshow = function () {
      // Something to do
    };
    instance.onclose = function () {
      // Something to do
    };
    if (sound) {
      instance.sound;
    }
    setTimeout(instance.close.bind(instance), timeout);
    return false;
  }
})();  