const express = require('express');
const app = express();
const fs = require('fs');
const WebSocket = require('ws');
const server = require('https').createServer({
  key: fs.readFileSync('/etc/letsencrypt/live/chat.prayer4.me/privkey.pem'),
  cert: fs.readFileSync('/etc/letsencrypt/live/chat.prayer4.me/cert.pem'),
}, app);
var io = require('socket.io')(server, { 'pingTimeout': 25000, 'pingInterval': 60000 });
// var test = new WebSocket.Server({ server });
// console.log(test);
// io.configure( function() {
//     io.set('close timeout', 60*60*24); // 24h time out
// });
const port = process.env.PORT || 9000;

//app.use(express.static(__dirname + '/public'));

app.use(express.static(__dirname + '/public')) // relative path of client-side code
app.get('/', function(req, res) {
    res.sendFile('index.html', { root: __dirname })
})
app.get('/*', function(req, res) {
  res.sendFile('public/index.html', { root: __dirname })
})

var mysql = require('mysql');

// var connection = mysql.createConnection({
//   host: '162.243.174.98',
//   user: 'pteghwngxc',
//   password: 'J4fhuw4WH5',
//   database: 'pteghwngxc'
// });

var connection = mysql.createPool({
  connectionLimit : 1000000000,
   host: '162.243.174.98',
  user: 'pteghwngxc',
  password: 'J4fhuw4WH5',
  database: 'pteghwngxc'
});
// connection.connect(function (err) {
//   // console.log('connected to mysql');
//   if (err) console.log("MySql Error=>"+err)
// })

io.on('connect', onConnect);
server.listen(port, function () {
  // console.log("Server Created with port "+port);
  var updateDateTime = new Date().toISOString().replace(/T/, ' ').replace(/\..+/, '');
  var sql = "UPDATE auth_chat_window SET is_disconnected = 'Y', disconnected_at = '" + updateDateTime + "' WHERE is_disconnected = 'N'";
  connection.query(sql, function (err, result) {
    if (err) {
      throw err;
    }
    // console.log("Number of records Updated: " + result.affectedRows);
  });
});

// function sendHeartbeat(){
//     setTimeout(sendHeartbeat, 3000);
//     io.sockets.emit('ping', { beat : 1 });
// }
// setTimeout(sendHeartbeat, 3000);

function onConnect(socket) {
  // console.log("New user connected : " + socket.id);

  //  socket.on('pong', function(data){
  //       console.log("Pong received from client");
  //   }); 
  

  socket.activeGroups = [];
  socket.userId = "";
  socket.yourDetail = "";
  socket.findTheGroup = "";
  socket.groupSocketIds = [];
  socket.groupDetals = "";
  socket.chatDetails = [];

  

  /*
   **@START : Get Group details on load
   **
   **GET user details also
   */
  socket.on("pageReady", data => {
    // console.log("Connected!");
    var sqlUser = 'SELECT id, first_name, last_name, CONCAT(SUBSTRING(first_name, 1,1), SUBSTRING(last_name, 1,1)) AS "short_name", phone, avatar, company_id FROM users WHERE identity_key = "' + data.userId + '"';
    connection.query(sqlUser, function (error, resultUser) {
      if (error) {
        console.log("Error! Query not run properly");
      } else {
        // console.log(resultUser);
        if (resultUser.length > 0) {
          socket.yourDetail = resultUser[0];
          socket.userId = socket.yourDetail.id;
          /*
          **@For : Check user requester or responder
          **
          **@ACTION : If socket.yourDetail.company_id is null then it's requester othewise responder.
          */ 
          if (socket.yourDetail.company_id == null) {
            var sql = 'SELECT group_id, CONCAT(SUBSTRING(group_id, 1,2), "-", SUBSTRING_INDEX(group_id, "-", -1)) AS "mob_group_id", expired_at, DATE_FORMAT(expired_at, "%a %e %b, %Y %l:%i %p") AS expired_at_format, IF(TIME_TO_SEC(TIMEDIFF(expired_at, NOW())) > 0, 1, 0) AS check_expired_at, first_name, last_name, avatar FROM requester_groups g, users u WHERE g.requester_id = u.id AND g.expired_at > NOW() AND g.requester_id = ' + socket.yourDetail.id + ' ORDER BY g.expired_at DESC';
          } else {
            var sql = 'SELECT group_id, CONCAT(SUBSTRING(group_id, 1,2), "-", SUBSTRING_INDEX(group_id, "-", -1)) AS "mob_group_id", expired_at, DATE_FORMAT(expired_at, "%a %e %b, %Y %l:%i %p") AS expired_at_format, IF(TIME_TO_SEC(TIMEDIFF(expired_at, NOW())) > 0, 1, 0) AS check_expired_at, first_name, last_name, avatar FROM requester_groups g, users u WHERE g.requester_id = u.id AND g.expired_at > NOW() AND g.company_id IN (' + socket.yourDetail.company_id + ', ' + socket.yourDetail.id + ') ORDER BY g.expired_at DESC';
          }

          //console.log(sql);
          connection.query(sql, function (error, result) {
            if (error) {
              // console.log(sql);
              console.log("Error! Query not run properly");
            } else {
              // console.log(result);
              socket.activeGroups = result;
              // console.log(socket.activeGroups);
              if (result.length > 0) {
                io.sockets.emit("sendAllGroupDetals", {
                  result: "success",
                  resNote: "sucess",
                  socketId: socket.id,
                  activeGroups: result,
                  userDetails: socket.yourDetail,
                  dateTime: new Date().toISOString().replace(/T/, ' ').replace(/\..+/, '')
                });
              } else {
                io.sockets.emit("sendAllGroupDetals", {
                  result: "error",
                  resNote: "No active groups.",
                  socketId: socket.id,
                  activeGroups: [],
                  userDetails: socket.yourDetail,
                  dateTime: new Date().toISOString().replace(/T/, ' ').replace(/\..+/, '')
                });
              }
            }
          });
        } else {
          io.sockets.emit("userNotFound", {
            result: "error",
            resNote: "No active users."
          });
        }
      }
    });
  });
  /*
   **@END : Get Group details on load
   */


  /*
   **@START : Get Group chat details
   **
   */
  socket.on("findTheGroupChat", data => {
    // console.log("Connected!");
    /*
      **@For : First find the group details
      **
      */
    var sql = 'SELECT r.id, r.requester_id, r.group_id, CONCAT(SUBSTRING(group_id, 1,2), "-", SUBSTRING_INDEX(group_id, "-", -1)) AS "mob_group_id", r.company_id, u.avatar, r.expired_at, r.is_chat_started_by_responder, IF(TIME_TO_SEC(TIMEDIFF(r.expired_at, NOW())) > 0, 1, 0) AS check_expired_at FROM requester_groups r, users u WHERE u.id = r.requester_id AND group_id = "' + data.findTheGroup + '"';
    connection.query(sql, function (error, result) {
      if (error) {
        console.log("Error! Query not run properly");
      } else {
        // console.log(result);
        socket.groupDetals = result[0];
        /*
          **@For : If the group found
          **
          **@ACTION : If the group found then check the socket associated with another group or not.
          */
        if (result.length > 0) {
          var sqlSel = 'SELECT id FROM auth_chat_window WHERE socket_id = "' + socket.id + '" AND is_disconnected = "N"';
          connection.query(sqlSel, function (error, resultSel) {
            if (error) {
              console.log("Error! Query not run properly");
            } else {
              // console.log(resultSel);
              /*
                **@For : If the socket associated with another group
                **
                **@ACTION : Disconnect it from that group
                */
              if (resultSel.length > 0) {
                var updateDateTime = new Date().toISOString().replace(/T/, ' ').replace(/\..+/, '');
                var sql = "UPDATE auth_chat_window SET is_disconnected = 'Y', disconnected_at = '" + updateDateTime + "' WHERE socket_id = '" + socket.id + "'";
                connection.query(sql, function (err, result) {
                  if (err) {
                    throw err;
                  }
                  // console.log("Number of records Updated: " + result.affectedRows);
                });
              }
              /*
                **@For : Connected with the requested group
                **
                */
              var dateTime = new Date().toISOString().replace(/T/, ' ').replace(/\..+/, '');
              var sql = "INSERT INTO auth_chat_window (user_id, group_id, socket_id, created_at) VALUES ?";
              var values = [
                [socket.yourDetail.id, socket.groupDetals.group_id, socket.id, dateTime]
              ];

              connection.query(sql, [values], function (err, resultIns) {
                if (err) {
                  throw err;
                }
                // console.log("1 record inserted");
              });

              /*
                **@For : Fetch the chat details of the group.
                **
                */
              // console.log(dateTime);
              // console.log(result[0].expired_at.toISOString().replace(/T/, ' ').replace(/\..+/, ''));

              var expired_at = new Date(result[0].expired_at);
              var date_time_now = new Date(dateTime);

              if (expired_at < date_time_now) {
                // console.log('1');
              } else {
                // console.log('2');
              }

              var sqlMsg = 'SELECT first_name, msg_from_id, msg_body, avatar, DATE_FORMAT(c.created_at, "%a %e %b, %Y") AS created_date, DATE_FORMAT(c.created_at, "%l:%i %p") AS created_time, DATE_FORMAT(c.created_at, "%a %e %b, %Y %l:%i %p") AS created_datetime, c.created_at FROM users_chat_details c, users u WHERE c.msg_from_id = u.id AND c.group_id = "' + socket.groupDetals.group_id + '" ORDER BY c.created_at';
              connection.query(sqlMsg, function (error, resultMsg) {
                // console.log(resultMsg);
                if (error) throw error;
                socket.chatDetails = resultMsg[0];
                io.sockets.emit("sendGroupChatDetals", {
                  result: "success",
                  resNote: "sucess",
                  socketId: socket.id,
                  findYourself: socket.yourDetail,
                  findTheGroup: socket.groupDetals,
                  resultMsg: resultMsg,
                  dateTime: dateTime
                });
              });
              // console.log('-=-' + socket.chatDetails);
            }
          });
        } else {
          io.sockets.emit("sendGroupChatDetals", {
            result: "error",
            resNote: "Invalid group ID! Please try with an valid ID.",
            socketId: socket.id,
            findTheGroup: [],
            resultMsg: []
          });
        }
      }
    });
  });
  /*
   **@END : Get Group chat details
   **
   */

  /*
   **@START : Save the new message for requested group for the sender
   ** 
   */
  socket.on("new_message", data => { 
    var dateTime = new Date().toISOString().replace(/T/, ' ').replace(/\..+/, '');
    var isFirstTimeChatStartedByResponder = 'N';

    var sql = "INSERT INTO users_chat_details (msg_from_id, group_id, msg_body, created_at) VALUES ?";
    var values = [
      [socket.yourDetail.id, socket.groupDetals.group_id, data.message, dateTime]
    ];

    connection.query(sql, [values], function (err, resultIns) {
      if (err) throw err;
      console.log("1 record inserted");

      var sqlGrp = 'SELECT user_id, group_id, socket_id FROM auth_chat_window WHERE group_id = "' + socket.groupDetals.group_id + '" AND is_disconnected = "N"';
      connection.query(sqlGrp, function (error, resultFindAllUserId) {
        if (error) throw error;
        if (resultFindAllUserId.length > 0) {
          // console.log(resultFindAllUserId);
          socket.groupSocketIds = resultFindAllUserId;

          if ((socket.yourDetail.company_id !== null) && (socket.groupDetals.is_chat_started_by_responder == 'N')) {
            isFirstTimeChatStartedByResponder = 'Y';
            socket.groupDetals.is_chat_started_by_responder = 'Y';

            var sqlGrpUpdate = "UPDATE requester_groups SET is_chat_started_by_responder = 'Y' WHERE group_id = '" + socket.groupDetals.group_id + "'";
            connection.query(sqlGrpUpdate, function (error, resultGrpUpdate) {
              if (error) throw error;
              console.log("Updated after first responce from responder: " + resultGrpUpdate.affectedRows);
            });
          }
        } 

        io.sockets.emit("new_message", {
          message: data.message,
          yourDetail: socket.yourDetail,
          socketId: socket.id,
          dateTime: dateTime,
          userId: socket.userId,
          groupSocketIds: socket.groupSocketIds,
          groupDetals: socket.groupDetals,
          isFirstTimeChatStartedByResponder: isFirstTimeChatStartedByResponder
        });


      });
    });
  });
  /*
   **@END : Save the new message for requested group for the sender
   **
   */


  /*
   **@START : Response for typing message indication
   */
  socket.on("typing", data => {
    var sql = 'SELECT user_id, group_id, socket_id FROM auth_chat_window WHERE group_id = "' + socket.groupDetals.group_id + '" AND is_disconnected = "N"';
    connection.query(sql, function (error, resultFindAllUserId) {
      if (error) throw error;
      if (resultFindAllUserId.length > 0) {
        // console.log('-- / --');
        socket.groupSocketIds = resultFindAllUserId;
        // console.log(socket.groupSocketIds);
      }
      socket.broadcast.emit("typing", {
        yourDetail: socket.yourDetail,
        userId: socket.userId,
        groupSocketIds: socket.groupSocketIds
      });
    });
  });
  /*
   **@END : Response for typing message indication
   */

  /*
   **@START : Find the group list on Search
   **
   */
  socket.on("searchGroup", data => {
    if (socket.yourDetail.company_id == null) {
      var sql = 'SELECT group_id, CONCAT(SUBSTRING(group_id, 1,2), "-", SUBSTRING_INDEX(group_id, "-", -1)) AS "mob_group_id", expired_at, DATE_FORMAT(expired_at, "%a %e %b, %Y %l:%i %p") AS expired_at_format, IF(TIME_TO_SEC(TIMEDIFF(expired_at, NOW())) > 0, 1, 0) AS check_expired_at, first_name, last_name, avatar FROM requester_groups g, users u WHERE g.requester_id = u.id AND g.expired_at > NOW() AND g.requester_id = ' + socket.yourDetail.id + ' ';
    } else {
      var sql = 'SELECT group_id, CONCAT(SUBSTRING(group_id, 1,2), "-", SUBSTRING_INDEX(group_id, "-", -1)) AS "mob_group_id", expired_at, DATE_FORMAT(expired_at, "%a %e %b, %Y %l:%i %p") AS expired_at_format, IF(TIME_TO_SEC(TIMEDIFF(expired_at, NOW())) > 0, 1, 0) AS check_expired_at, first_name, last_name, avatar FROM requester_groups g, users u WHERE g.requester_id = u.id AND g.expired_at > NOW() AND g.company_id IN (' + socket.yourDetail.company_id + ', ' + socket.yourDetail.id + ') ';
    }

    if (data.search != '') {
      sql += 'AND g.group_id LIKE "%' + data.search + '%" ';
    }
    sql += 'ORDER BY g.expired_at DESC';
    // console.log(sql);

    connection.query(sql, function (error, result) {
      if (error) {
        console.log("Error! Query not run properly");
      } else {
        // console.log(result);
        socket.activeGroups = result;
        // console.log(socket.activeGroups);
        if (result.length > 0) {
          io.sockets.emit("sendSearchingGroup", {
            result: "success",
            resNote: "sucess",
            socketId: socket.id,
            activeGroups: result,
            userDetails: socket.yourDetail,
            groupDetals: socket.groupDetals,
            dateTime: new Date().toISOString().replace(/T/, ' ').replace(/\..+/, '')
          });
        } else {
          io.sockets.emit("sendSearchingGroup", {
            result: "error",
            resNote: "No active groups.",
            socketId: socket.id,
            activeGroups: [],
            userDetails: socket.yourDetail,
            groupDetals: socket.groupDetals,
            dateTime: new Date().toISOString().replace(/T/, ' ').replace(/\..+/, '')
          });
        }
      }
    });
  });
  /*
   **@END : Find the group list on Search
   */

  /*
   **@START : When any user leave the chat then, mark the socket as disconnected
   */
  socket.on('disconnect', function () {
    // console.log("Disconnected Socket = " + socket.id);
    var updateDateTime = new Date().toISOString().replace(/T/, ' ').replace(/\..+/, '');
    var sql = "UPDATE auth_chat_window SET is_disconnected = 'Y', disconnected_at = '" + updateDateTime + "' WHERE socket_id = '" + socket.id + "'";
    connection.query(sql, function (err, result) {
      if (err) throw err;
      // console.log("Number of records Updated: " + result.affectedRows);
    });
  });
  /*
   **@END : When any user leave the chat then, mark the socket as disconnected
   */
}

